////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995-2003 Xilinx, Inc.
// All Right Reserved.
////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 10.1
//  \   \         Application : ISE
//  /   /         Filename : myTest_selfcheck.tfw
// /___/   /\     Timestamp : Tue Nov 03 16:10:14 2009
// \   \  /  \ 
//  \___\/\___\ 
//
//Command: 
//Design Name: myTest_selfcheck_beh_0
//Device: Xilinx
//
`timescale 1ns/1ps

module myTest_selfcheck_beh_0;
    reg Clear = 1'b0;
    reg CLK = 1'b0;
    reg [15:0] Exponenti = 16'b0000000000000000;
    reg Load = 1'b0;
    reg [47:0] Mantise = 48'b000000000000000000000000000000000000000000000000;
    reg Op = 1'b0;
    wire [7:0] Exponent;
    wire [23:0] Mantisa;

    parameter PERIOD = 60;
    parameter real DUTY_CYCLE = 0.5;
    parameter OFFSET = 30;

    initial    // Clock process for CLK
    begin
        #OFFSET;
        forever
        begin
            CLK = 1'b0;
            #(PERIOD-(PERIOD*DUTY_CYCLE)) CLK = 1'b1;
            #(PERIOD*DUTY_CYCLE);
        end
    end

    TopLevel UUT (
        .Clear(Clear),
        .CLK(CLK),
        .Exponenti(Exponenti),
        .Load(Load),
        .Mantise(Mantise),
        .Op(Op),
        .Exponent(Exponent),
        .Mantisa(Mantisa));

    integer TX_ERROR = 0;
    
    initial begin  // Open the results file...
        #1060 // Final time:  1060 ns
        if (TX_ERROR == 0) begin
            $display("No errors or warnings.");
        end else begin
            $display("%d errors found in simulation.", TX_ERROR);
        end
        $stop;
    end

    initial begin
        // -------------  Current Time:  285ns
        #285;
        Exponenti = 16'b0000010011010010;
        Mantise = 48'b000000000000000001001000110110111000010000011010;
        // -------------------------------------
    end

    task CHECK_Exponent;
        input [7:0] NEXT_Exponent;

        #0 begin
            if (NEXT_Exponent !== Exponent) begin
                $display("Error at time=%dns Exponent=%b, expected=%b", $time, Exponent, NEXT_Exponent);
                TX_ERROR = TX_ERROR + 1;
            end
        end
    endtask
    task CHECK_Mantisa;
        input [23:0] NEXT_Mantisa;

        #0 begin
            if (NEXT_Mantisa !== Mantisa) begin
                $display("Error at time=%dns Mantisa=%b, expected=%b", $time, Mantisa, NEXT_Mantisa);
                TX_ERROR = TX_ERROR + 1;
            end
        end
    endtask

endmodule

